<?php
/* --------------------------------------------------------------
   WithdrawalFilters.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\SqlCriteria;

use ArrayIterator;
use Gambio\Core\Criteria\SqlFilters;
use Traversable;

/**
 * Class WithdrawalFilters
 *
 * @package Gambio\Admin\Withdrawal\SqlCriteria
 */
class WithdrawalFilters implements SqlFilters
{
    /**
     * @var WithdrawalFilter[]
     */
    private $filters;
    
    
    /**
     * WithdrawalFilters constructor.
     *
     * @param WithdrawalFilter ...$filters
     */
    private function __construct(WithdrawalFilter ...$filters)
    {
        $this->filters = $filters;
    }
    
    
    /**
     * @param WithdrawalFilter ...$filters
     *
     * @return WithdrawalFilters
     */
    public static function create(WithdrawalFilter ...$filters): WithdrawalFilters
    {
        return new self(...$filters);
    }
    
    
    /**
     * @param WithdrawalFilter ...$filters
     *
     * @return $this
     */
    public function add(WithdrawalFilter ...$filters): self
    {
        $this->filters = array_merge($this->filters, $filters);
        
        return $this;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->filters);
    }
}